/*:
 * @plugindesc Adds a "Load" option to the in-game menu in RPG Maker MV.
 * @author Bitshift
 *
 * @help
 * This plugin adds a "Load" command to the in-game menu, allowing players to
 * access the load screen directly from the menu.
 */

// Add Load command to the main menu
(function() {
    // Alias the addOriginalCommands method to add the Load command
    var _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function() {
        _Window_MenuCommand_addOriginalCommands.call(this); // Call the original method
        this.addCommand('读档', 'load', true); // Add the Load command
    };

    // Alias the createCommandWindow method to add the Load handler
    var _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function() {
        _Scene_Menu_createCommandWindow.call(this); // Call the original method
        this._commandWindow.setHandler('load', this.commandLoad.bind(this)); // Add handler for Load
    };

    // Define the commandLoad method to push Scene_Load
    Scene_Menu.prototype.commandLoad = function() {
        SceneManager.push(Scene_Load);
    };
})();